// ---------------
// TO-DOs / Checks
// ----------------

// - Formatierung der double-Werte - InOut? System.out.printf("%.0f",Startkapital-Betriebskasse.Kassenstand); ginge auch
// - Z36: double - Limit (long / int) was?

// --------------------------------------------
// Release-Notes und Erweiterungsmglichkeiten:
// --------------------------------------------

// - Verlust = Ausgaben und Bergeverluste zusammen (betriebswirtschaftlich nicht ok, aber fr Spiel reichts, sonst auch hier 2 sep. Var. fhren und aufsummieren)
// - Herumexperimentieren mit unterschiedlichen Instandsetzungsfaktoren pro Schiff, bzw. Inbetriebnahme (Aussetzung), Platz belegt durch Schiff
// - Spiele while (true)s wurden verwendet wegen Breaken und nicht goto, bzw. neuer Eingabe verlangen (=Rcksprungmglichkeit emuliert)
// - 2 Listen (Schiffe und auszuscheidende Schiffe wurden verwendet, wege Exception in laufender Schleife bei remove-Anwendung
// - keine explizite Schiffe_fahren-lass-Methode erforderlich, da dies Monat fr Moant in der Dauerschleife erfolgt
// - Zusatzfeatures: Monatszhler, Schiffsbau-, Sink-, Verschrottungszhler, Konkursmassenausgabe bei Bankrott

/* Grobkozept und Programmgliederung:

-> Initialisierung

-> Namensabfragung der SpielerIn

-> Initialausgabe des Programms

MONATSSCHLEIFE (Dauerschleife mit hochzhlenden Monaten)
{
	-> Schiffe werden fahren gelassen
	
	-> Statusausgabe zur Lage (Schiffe, Kapital)
	
	-> MENSCHLEIFE mit Switch-Anweisung, wo in die einzelnen Aktionen hineingesprungen wird
	   {	
		-> nach gltiger Eingabe wird zur bergeordneten Spieldauerschleife "gebreaked", wo erneut die Schiffe fahren gelassen und der Status ausgegeben wird
		
		-> Programmende erfolgt durch Wahl in der Switch-Anweisung mit "Programmende", bzw. durch Bankrottexception, wenn ein bersehenes Schiff untergeht und die Bergekosten nicht mehr drin sindt
		
		-> bei den Aktionen in der Switch-Anweisung selbst kann kein Bankrott erfolgen (Schiff bauen, Verschrotten oder Streichen, da dort der Kassenstand ohnehin geprft wird)
		
			SWITCH:
				FRACHTERBAU
				TANKERBAU
				PASSAGIERSCHIFFBAU
				VERSCHROTTEN
				STREICHEN
				NICHTS
				PROGRAMMENDE

	   } // ENDE MENSCHLEIFE	

} // ENDE MONATSSCHLEIFE

*/

package main;

import java.util.*;
import inout.them.fhb.at.InOut;
import inout.them.fhb.at.InOutException;
import werftobjekte.*;

public class Main {
	
	public static void main(String[] args) {

    // ----------------------------------------
	// Eingabe- und Initialisierungsteil-Start:
	// ----------------------------------------
		
	// Menkonstanten fr Hauptswitch-Kommando in der Spieleschleife
		
	final int       Frachterbau	 				= 						  1;     
	final int       Tankerbau 	  	 			= 						  2;
	final int       Passagierschiffbau 			= 						  3;
	final int       Verschrottung      			= 						  4;
	final int       Streichung         			= 						  5;
	final int       Blaumachung        			= 						  6;	    
    final int       Programmende       		    = 						  7;

    // Statuscodes fr regulres, bzw. Zwangsende des Spiels (fr system.exit)
    
    final int       Ende_regulaer   		    = 						  0;
    final int       verloren       		        = 						255;    
    
    final double	Startkapital				=			      500000000; // hier kann man das Startkapital erhhen (je nach Wunsch)

    // statistische Variablen anlegen

//XXX folgende Variablen sind angedacht fr ein eigenes Objekt, aber war nicht erforderlich: Werft Schifsswerft = new Werft();     

    int			    Gesamtbauzaehler            = 						  0;
    int				Gesamtverschrottungszaehler =						  0;
    int				Gesamtsinkzaehler           = 						  0;
    
    // sonstige Variablen anlegen
    
	int             Monatscounter			    = 						  0; // Monat startet bei 0, da in Schleife stndig erhht wird solange das Spiel luft, d.h. wird dort 1 beim 1. Mal
    int             Schiffsnummer 		        = 						  1; // erste zu vergebende Schiffsnummer
	int             Sinkzaehler                 = 						  0; // zu Beginn ist noch kein Schiff gesunken
	
	int             x							= 						  0; // Men-Index -> darin wird die Menauswahl zwischengespeichert
	int             z							= 						  0; // Schiffsverschrottungs-, bzw. -streichungsindex -> darin wird das ausgewhlte Schiff fr die Verschrottung oder Streichung zwischengespeichert

	boolean         Flottenvorhandencheck       =                     false; // zuerst muss nicht 2x auf Vorhandensein einer Flotte geprft werden (erst im Spielverlauf, wenn welche sinken knnen -> das kann auch die ganze Flotte betreffen)
	
 	LinkedList <Schiff> Flotte   				= new LinkedList <Schiff>(); // Flottenliste initialisieren (am Anfang ist die natrlich leer, da kein Schiffsobjekt drinnen ist -> muss Spieler erst einkaufen) 
    LinkedList <Schiff> ausscheidende_Schiffe   = new LinkedList <Schiff>(); // Remove in Iterationsschleife geht nicht, da es Exception werfen wrde, d.h. Zwischenliste fr zu entfernende Schiffe anlegen und daraus dann die Schiffe in der Flotte entfernen lassen 

 	Kassa 			Betriebskasse 				= new Kassa  (Startkapital); // Kasse initialisieren -> Spiel startet mit 500 Mio. Cash

	// Referenzschiffe anlegen, um Vergleichswerte fr Preise und Verschrottungskosten zu haben, wenn direktes Schiffsobjekt nicht verfgbar, bzw. noch nicht angelegt oder schon verschrottet ist
	
	Passagierschiff Referenzpassagierschiff 	= new Passagierschiff   (0);
	Frachter        Referenzfrachter        	= new Frachter          (0);
	Tanker          Referenztanker          	= new Tanker            (0);
	
	String 			Sie							= 						 ""; // Initialisierung als Leerstring (hier kommt dann der Spielername rein)
	
	// ---------------------------------------------------------------------------
	// !!!!!!!!!!!!!!!!!!ACHTUNG: KORREKT GENDERN FR DIE MDELS!!!!!!!!!!!!!!!!!!
	// ---------------------------------------------------------------------------
	
	InOut.printString( "__________________________________________________________________________________________________________________________"  );	
	InOut.printString( "WerftmanagerIn v0.9a - (c) 10/2015 by www.gossmann.at - portions copyright by Dr. Robert Matzinger / FH-Burgenland (InOut)"  );
	InOut.printString( "__________________________________________________________________________________________________________________________\n");

	// Namen vom Spieler holen, damit das Spiel persnlicher wird...
	
	try {
	    Sie = InOut.readString("Wie lautet Ihr Name:"				   );
	    }
	catch (InOutException e)
	    {
		InOut.printString("falsche Eingabe - Programm wird terminiert!");
		}
	// ------------------------------------------------------------------------------------------------
	// !!!!!!!!!!!!!!!!!!ACHTUNG: AUCH HIER ALLENFALLS KORREKT GENDERN FR DIE MDELS!!!!!!!!!!!!!!!!!!
	// ------------------------------------------------------------------------------------------------
    
	if (Sie.length() == 0) Sie="AnonymousIn"; // wurde nichts eingegeben, dann heit der Benutzer "AnonymousIn" 

	// --------------------
	// Hauptprogramm-Start:
	// --------------------
	
	// Spieldauerschleife -> Endlosgefahr besteht hier nicht, da Spieler im Men Programmende whlen kann und damit das Programm endet
	
	while (true) {
		
		  Monatscounter++; // ein neuer Monat bricht an
		  Sinkzaehler = 0; // Schiffe sind diesen Monat noch keine gesunken
		
		  InOut.printString("\nSpielmonat: " + Monatscounter             );
		  InOut.printString("\naktueller Flotten- und Werft-Lagebericht:");
		  InOut.printString("_________________________________________\n");

 		  // zu Spielstart kann natrlich noch keine Flotte vorgelegen haben (auch wenn der Spieler alle Schiffe verschrottet, liegt keine vor) -> Test ob Flotte vorhanden ist
		
		  if (Flotte.isEmpty()) {
	         InOut.printString("Sie verfgen derzeit ber keine Schiffe"); // allenfalls Meldung machen, dass (noch) keine Flotte (mehr) vorhanden ist
	         Flottenvorhandencheck = false							     ; // fr unteren 2. Test nachdem die Schiffe gefahren sind, Flag setzen, dass nicht mehr getestet werden muss (von selbst entsteht kein Schiff)
		     }
		  else
		     {

			 // eine Flotte aus mind. 1 Schiff ist also vorhanden an dieser Stelle -> Gewinn einfahren lassen oder eben Verlust (wenn es sinkt)
			
			 Betriebskasse.Monatsgewinn  = 0; // Gewinn in der Kasse fr diesen Monat initialisieren (ist solange noch kein Schiff gefahren ist 0)
    		
			 // gesamte vorhandene Flotte abgrasen
		     for (Schiff y : Flotte) {    
		    	 	    	
		    	 if (y.Intaktheitsfaktor>=25) 			          	     // Test 1: ist die betreffende Schiffshlle berhaupt noch intakt? 
		    	   {
                   if (y.Inbetriebnahme_nach_Monaten>0)           	     // Test 2: dauert es noch bis zur (Wieder)inbetriebnahme des Schiffes (nach Neubau oder Streichung)?
                      {  
         		      y.Inbetriebnahme_nach_Monaten--           	   ; // ist das Schiff noch in Bau / Streichung, dann setzt das betreffende Schiff diesen Monat aus, aber Monatszler verringern (bis es wieder einsatzbereit ist) 
                 	  continue						                   ; // weitermachen mit nchstem Schiff (so eben vorhanden)
                      }
		    	   Betriebskasse.Eingang                     (y.Gewinn); // alles ok bis hier, dann zuerst den monatlichen Profit fr das jeweilige Schiff vereinnahmen
		    	   Betriebskasse.Monatsgewinn+=         	   y.Gewinn; // separat den Monatsgewinn aller Schiffe aufsummieren lassen
		    	   y.Profit_durch_dieses_Schiff+=       	   y.Gewinn; // separat den Anteil des Gewinns pro Schiff verbuchen
		    	   y.Intaktheitsfaktor=y.Intaktheitsfaktor*y.Rostfaktor; // jetzt noch den monatlichen Verschlei der Hlle des jeweiligen Schiffes abziehen	    	   
		    	   
		    	   }
		    	else                                              	     //  Schiff ist an dieser Stelle nicht mehr intakt -> es spielt daher Titanic und sinkt
		    	   {
		    	   ausscheidende_Schiffe.add(y)					       ; // in anderer Liste die auszuscheidenden (sinkenden) Schiffe sammeln
		    	   Sinkzaehler++			                    	   ; // Anzahl der gesunkenen Schiffe in diesem Monat erhhen
		    	   Gesamtsinkzaehler++								   ; // die Sinkstatistik pflegen
		    	   Flottenvorhandencheck = 		  			       true; // nun muss spter geprft werden, ob allenfalls alle Schiffe versunken sind und daher keine Flotte mehr da ist, die man ausgeben knnte

		    	   try {
		    	       Betriebskasse.Ausgang  (y.Bergungskosten); // auch die zwangsweise erforderlichen Bergekosten abziehen (nur hier kann Bankrott auftreten, da ansonsten eh berall geprft wird, ob genug Geld vorhanden ist)		           
   	    		       }
                   catch (Bankrottexception e)
            	       {
		               InOut.printString("Sie sind bankrott!!!"); // Meldung machen, dass Spieler bankrott ist (=verloren hat)
                       
		               InOut.printString("\nUnter Ihrem Kommando wurden: "  + Gesamtbauzaehler            + " Schiff(e) gebaut."                       );
		               InOut.printString("Unter Ihrem Kommando wurden: "    + Gesamtverschrottungszaehler + " Schiff(e) regulr verschrottet."         );
		               InOut.printString("Unter Ihrem Kommando versanken: " + Gesamtsinkzaehler           + " Schiff(e)."                              );
		                
	                   InOut.printString( "\nIhr Kassenstand nach "+Monatscounter+" Monate(n) betrgt: "+String.valueOf(Betriebskasse.Kassenstand)+"\n");
 	                   
	                   // da Spieler verloren hat, ist Kassenstand automatisch negativ und damit ein Verlust vorhanden
	                   
	                   InOut.printString("Dies entspricht einem Verlust von: " + String.valueOf(Startkapital-(Startkapital+Betriebskasse.Kassenstand)) ); // +, da minus minus plus gbe

	      			   if (Flotte.isEmpty()==false) InOut.printString("\nSie verfgen noch ber folgende Konkursmasse an Schiffen\n"); // Konkursmasse noch ausgeben, wenn noch Schiffe da               												   								

	      			   // Schiff k wegen y schon vergeben (K)onkurs passt eh...
	    			   for (Schiff k : Flotte) {
	    			       if (k.Intaktheitsfaktor>=25) // nur die intakten und nicht die versunkenen Schiffe ausgeben // msste erst unten gesondert entfernt werden in anderer Objektschleife (wegen Exception)
	    			    	  {
	    				      InOut.printString("___________________________________________________________________________\n"												   															   );
	    				      InOut.printString("Typ: "+k.getClass().getName()+" Nr.: "+String.valueOf(k.Schiffsnummer)												   																	   );
	    				      InOut.printString("-> intakt zu: "+String.valueOf(k.Intaktheitsfaktor)+" - bereits: "+String.valueOf(k.Anzahl_Streichungen)+ "x gestrichen - erzielter Profit: "+String.valueOf(k.Profit_durch_dieses_Schiff));
	    				      InOut.printString("___________________________________________________________________________"													   														   );
	    			    	  }
	    			   }
	                   
	                   InOut.printString( "\nLeider verloren!" );		               

	                   System.exit				      (verloren); // Programmende mit Code fr verloren
	                   }

                   Betriebskasse.Monatsverlust+=y.Bergungskosten; // separat den Monatsverlust aufsummieren

//XXX gab Zores	   Flotte.remove(y)				                ; // das Schiff aus der Flotte ausscheiden lassen
//XXX -> wenn ber Objekte iteriert wird, darf man die iterierten Objekte nicht ndern (geht so nicht -> current modification exception)

//XXX -> Abhilfe mit ausscheidender Schiffsliste:
		    	   
		    	   }
		     } // end for 
		     
		     // jetzt die allenfalls gesammelten versunkenen Schiffe aus der Flotte entfernen
		     for (Schiff y : ausscheidende_Schiffe) {
		     Flotte.remove(y);
		     }
		     
		     ausscheidende_Schiffe.clear(); // die gesammelten versunkenen Schiffe aus der Zwischenliste lschen
		     
		     } // end else-Zweig

		  // neuerlicher Test, ob (noch) Schiffe da sind -> es knnten ja immerhin alle gesunken sein, falls oben das Testflag gesetzt wurde
		  // (Flag dient dazu, nicht unmittelbar nach Programmstart die Zeile, dass keine Schiffe vorhanden sind doppelt auszugeben
		  if ( (Flotte.isEmpty()) && (Flottenvorhandencheck==true) ) {
		     InOut.printString("Sie verfgen derzeit ber keine Schiffe"); // allenfalls Meldung machen, dass (noch) keine Flotte (mehr) vorhanden ist
		     }
		  else
		     {
			 // falls beim Fahren oben nicht alle Schiffe gesunken sind (Flotte leer wurde), nun die vorhandene Flotte ausgeben
 		     // der Flottenbersichtsbericht muss ausgegeben werden, wenn noch mind. 1 Schiff in der Flotte aufscheint, was durch die Schleife automatisch geschieht
			 // der Bericht beinhaltet Schiffstyp, deren Nummer sowie den akt. Intaktheitsstatus der Hlle, die bereits gettigten Streichungen sowie den eingefahrenen Gewinn

			 if (Flotte.isEmpty()==false) InOut.printString("\nSie verfgen ber die folgende Flotte an Schiffen\n"); // bei Spielstart ist die Flotte noch leer, da darf die Zeile nicht ausgegeben werden               												   								

			 for (Schiff y : Flotte) {
			     InOut.printString("___________________________________________________________________________\n"												   															  );
	    	     InOut.printString("Typ: "+y.getClass().getName()+" Nr.: "+String.valueOf(y.Schiffsnummer)												   																	  );
	    	     InOut.printString("-> intakt zu: "+String.valueOf(y.Intaktheitsfaktor)+" - bereits: "+String.valueOf(y.Anzahl_Streichungen)+ "x gestrichen - erzielter Profit: "+String.valueOf(y.Profit_durch_dieses_Schiff));
	    	     InOut.printString("___________________________________________________________________________"													   														  );
			 
		     } // end for
		     } // end else

     	  // auf jeden Fall aber (ob Schiffe vorhanden waren oder nicht) die Gesamteinnahmen / Verluste und Anzahl allfllig versunkener Schiffe ausgeben:
		  
		  InOut.printString("\nDie Gesamteinnahmen in diesem Monat beliefen sich auf: "             +String.valueOf(Betriebskasse.Monatsgewinn ));
     	  InOut.printString("\nDie Gesamtausgaben bzw. Verluste in diesem Monat beliefen sich auf: "+String.valueOf(Betriebskasse.Monatsverlust));
       	  if (Sinkzaehler>0) InOut.printString("\nFolgende Anzahl an Schiffen ist versunken: "+String.valueOf                      (Sinkzaehler));

  	      Betriebskasse.Monatsverlust = 0; // erst nach der monatlichen Gewinn- / Verlustausgabe den Monatsverlust neu initialisieren, denn ab hier kann der Spieler Geld ausgeben, was im nchsten Monat dann zu buche schlgt

          // Hauptswitch-Anweisung folgt in der Schleife da drin - dient zur Aufforderung einer neuen Eingabe, wenn sich es Spieler berlegt hat, zu streichen oder verschrotten, oder das Geld fr eine Aktion nicht reicht  	      
          // Label dient zu korrektem, zielgerichtetem "breaken"

 Eingabe: while (true) { 		
             	
	            // zuerst das Hauptmen mit den mglichen Aktionen ausgeben
	 
	            try {	
		            x = InOut.readMenu("\n"+Sie+", Sie verfgen ber "+ String.valueOf(Betriebskasse.Kassenstand)+" Cash, was wollen Sie damit tun?\n",
			            "Frachter bauen (30 Mio.)@Tanker bauen (70 Mio.)@Passagierschiff bauen (150 Mio.)@Schiff verschrotten (1/10 des Kaufpreises)@Schiff streichen (F: 1, T: 3, P: 5 Mio.)@nichts, blau machen und weiter@Programmende\n");
	                }
                catch (InOutException e)
             	    {
		            InOut.printString("fehlerhafte Eingabe - Programm wird abgebrochen.");
	                }
		
	            // anhand der gewnschten Aktion reagieren:
	            
	            switch ((int) x) {

	            		//   ------------    
	                    case Frachterbau:
	                    //   ------------
	                    	
	                    // prfen, ob Spieler sich den Bau des Frachters berhaupt leisten kann

	                    if (Betriebskasse.Kassenstand<Referenzfrachter.Preis)
	                       {
         	               InOut.printString("\nSie haben leider nicht genug Geld in der Kasse zum Bau eines Frachters");
    	                   continue Eingabe																		        ; // nein - weiter mit neuer Eingabe
    	                   }

	                   	// ja, er kann
		
	                    Betriebskasse.Ausgabe(Referenzfrachter.Preis)      ; // Schiffspreis von der Kasse abziehen
	                    Betriebskasse.Monatsverlust+=Referenzfrachter.Preis; // Aufsummierung des Monatsverlustet (in dem Fall eine Ausgabe fr den Kaufpreis des Schiffes)
	                    Flotte.add(new Frachter(Schiffsnummer))            ; // neues Schiff in Flotte aufnehmen
	                    Gesamtbauzaehler++								   ; // die Baustatistik pflegen
	                    Schiffsnummer++		       	                       ; // fr nchstes Schiff die Schiffsnummer erhhen

	                    break Eingabe						               ; // Ende der Men-Aktionsschleife an der Stelle und weiter mit neuem Monat nachher    	

	            		//   ----------    
	                    case Tankerbau:
	                    //   ----------

	                    // prfen, ob Spieler sich den Bau des Tankers berhaupt leisten kann

	                    if (Betriebskasse.Kassenstand<Referenztanker.Preis)
	                       {
	                       InOut.printString("\nSie haben leider nicht genug Geld in der Kasse zum Bau eines Tankers");
	                       continue Eingabe		   																      ; // nein - weiter mit neuer Eingabe
	                       }

	                    // ja, er kann
	                    
	   	                Betriebskasse.Ausgabe(Referenztanker.Preis)      ; // Schiffspreis von der Kasse abziehen	                    
	                    Betriebskasse.Monatsverlust+=Referenztanker.Preis; // Aufsummierung des Monatsverlustet (in dem Fall eine Ausgabe fr den Kaufpreis des Schiffes)
	                    Flotte.add(new Tanker(Schiffsnummer))            ; // neues Schiff in Flotte aufnehmen
	                    Gesamtbauzaehler++						 	     ; // die Baustatistik pflegen
	                    Schiffsnummer++		       	                     ; // fr nchstes Schiff die Schiffsnummer erhhen

	                    break Eingabe						             ; // Ende der Men-Aktionsschleife an der Stelle und weiter mit neuem Monat nachher   	

	            		//   -------------------    
	                    case Passagierschiffbau:
	                    //   -------------------

		                // prfen, ob Spieler sich den Bau des Passagierschiffes berhaupt leisten kann

	                    if (Betriebskasse.Kassenstand<Referenzpassagierschiff.Preis)
	                       {
	                       InOut.printString("\nSie haben leider nicht genug Geld in der Kasse zum Bau eines Passagierschiffes");
	                       continue Eingabe																		                ; // nein - weiter mit neuer Eingabe
	                       }

	                    // ja, er kann

	                    Betriebskasse.Ausgabe(Referenzpassagierschiff.Preis)      ; // Schiffspreis von der Kasse abziehen
	                    Betriebskasse.Monatsverlust+=Referenzpassagierschiff.Preis; // Aufsummierung des Monatsverlustet (in dem Fall eine Ausgabe fr den Kaufpreis des Schiffes)
	                    Flotte.add(new Passagierschiff(Schiffsnummer))            ; // neues Schiff in Flotte aufnehmen
	                    Gesamtbauzaehler++								          ; // die Baustatistik pflegen
	                    Schiffsnummer++		 		         	                  ; // fr nchstes Schiff die Schiffsnummer erhhen

	                    break Eingabe						  		              ; // Ende der Men-Aktionsschleife an der Stelle und weiter mit neuem Monat nachher    	

	            		//   --------------	                    
	                    case Verschrottung: 
		            	//   --------------         

	                   	// prfen, ob Spieler berhaupt ber Schiffe verfgt, die er verschrotten kann und allenfalls das Men neu anzeigen, falls nicht
    	
    	                if (Flotte.isEmpty()) 
                           {
        	               InOut.printString("\nSie verfgen derzeit ber keine Schiffe und knnen daher auch keines verschrotten");
        	               continue Eingabe		 														 			  	           ; // nein - weiter mit neuer Eingabe
                           }

    	                // Spieler hat Schiffe -> Verschrottungsfrage kann gestellt werden, indem der Spieler um die Schiffsnummer gebeten wird:
    	               
    	                try {	
    	            	    z = InOut.readIntBetween("Bitte das zu verschrottende Schiff anhand seiner Nummer eingeben (0=keines, ansonsten derzeit eine Flotte von 1-"+String.valueOf(Schiffsnummer-1),0,Schiffsnummer-1);
    	               	    }
    	                catch (InOutException e)
    	                    {
    	            	    InOut.printString("fehlerhafte Eingabe - Programm wird abgebrochen."																														 );
    		                }

    	                if (z==0) continue Eingabe; // hat es sich der Spieler berlegt und will nun doch nicht verschrotten, dann neue Men-Aktionseingabe verlangen

    	                // nein -> er will wirklich verschrotten, dann Schiff anhand der vom Spieler eingegebenen Nummer suchen
    	 
    	                // gewnschtes Schiff suchen
    	                for (Schiff y : Flotte) {
  			 
    	            	    // gewnschtes Schiff gefunden?
  			 
    	            	    if (y.Schiffsnummer==z)
    	            	       {
    	            		   if (Betriebskasse.Kassenstand<y.Verschrottungskosten) // dann noch testen, ob genug Geld fr das Verschrotten dieses Schiffes in der Kasse ist
    	            		      {
    	            			  InOut.printString("Sie haben leider nicht genug Geld in der Kasse zur Verschrottung des ausgewhlten Schiffes."); // nein, das melden               
    	            			  continue Eingabe																							      ; // und weitermachen mit neuer Eingabe 
    	            		      }
    	            		   else																										            // ansonsten
    	            		      {
    	            			  Betriebskasse.Ausgabe(y.Verschrottungskosten)      															  ; // Verschrottungskosten von der Kasse abziehen
    	            			  Betriebskasse.Monatsverlust+=y.Verschrottungskosten															  ; // Aufsummierung des Monatsverlustet (in dem Fall die Ausgaben fr die Verschrottung des Schiffes)
    	            			  Gesamtverschrottungszaehler++																					  ; // die Verschrottungsstatistik pflegen

    	            			  // hier funktioniert der Remove in der Schleife ohne Exception, da sofort im Anschluss gebreaked wird und nicht weiter iteriert werden muss

    	            			  Flotte.remove(y)				  			        															  ; // Schiff aus dem Verkehr ziehen
    	            			  break Eingabe									    														 	  ; // weiter mit neuem Monat
    	            		      }
    	            	       }

    	                } // end for (Schiff y : Flotte)
    	
    	                break Eingabe; // eigentlich berflssig hier..., da oben im if Sprung schon erfolgt -> soll sich Compiler darum kmmern und optimieren
  		 
    	                //   -----------
	                    case Streichung:
	    	            //   -----------	                    	
    	
	                    // prfen, ob Spieler berhaupt ber Schiffe verfgt, die er streichen kann und allenfalls das Men neu anzeigen, wenn nicht
    	
	                    if (Flotte.isEmpty()) 
	                       {
	                       InOut.printString("\nSie verfgen derzeit ber keine Schiffe und knnen daher auch keines streichen");
	                       continue Eingabe		    													 			  	        ; // nein -> weiter mit neuer Eingabe
	                       }

	                    // Spieler hat Schiffe -> Streichungssfrage kann gestellt werden, indem der Spieler um die Schiffsnummer gebeten wird:
   	 
	                    try {	
	                    	z = InOut.readIntBetween("Bitte das zu streichende Schiff anhand seiner Nummer eingeben (0=keines, ansonsten derzeit eine Flotte von 1-"+String.valueOf(Schiffsnummer-1),0,Schiffsnummer-1);
	                    	}
	                    catch (InOutException e)
	                        {
	                    	InOut.printString("fehlerhafte Eingabe - Programm wird abgebrochen."																													  );
	                        }

	                   	if (z==0) continue Eingabe; // hat es sich der Spieler berlegt und will nun doch nicht streichen, dann neue Men-Aktionseingabe verlangen
    	    	
	                   	// nein -> er will wirklich streichen, dann Schiff anhand der vom Spieler eingegebenen Nummer suchen

    	                // gewnschtes Schiff suchen
    	                for (Schiff y : Flotte) {
  			 
    	            	    // gewnschtes Schiff gefunden?
  			 
    	            	    if (y.Schiffsnummer==z)
    	            	       {
	                   	       if (Betriebskasse.Kassenstand<=y.Streichungskosten) 																    // wenn nicht genug Geld fr das Streichen in der Kasse ist, bzw. das Schiff schon 3x gestrichen wurde
	                   	       	  {
	                   	    	  InOut.printString   ("Sie haben leider nicht genug Geld in der Kasse, um das ausgewhlte Schiff zu streichen." ); // das melden               
	                   	    	  continue Eingabe																						          ; // und weitermachen mit neuer Eingabe 
	                   	       	  }
	                   	       else																										            // ansonsten
	                   	          {
	                   	    	  if (y.Anzahl_Streichungen==3)																					    // noch prfen, ob das Schiff schon 3x gestrichen wurde, dann ist auch finito	
	                   	    	  {
	                   	    	  InOut.printString("Sie haben das Schiff leider schon 3x streichen lassen. Sie knnen es kein 4. Mal streichen."); // allenfalls auch das melden
	                   	    	  continue Eingabe																						          ; // und weitermachen mit neuer Eingabe
	                   	    	  }

	                   	    	  Betriebskasse.Ausgabe(y.Streichungskosten)      																  ; // Streichungskosten von der Kasse abziehen
	                   	    	  Betriebskasse.Monatsverlust+=y.Streichungskosten																  ; // Aufsummierung des Monatsverlustet (in dem Fall die Ausgaben fr die Steichung des Schiffes)
	                   	    	  y.Anzahl_Streichungen++ 																					      ; // Streichung vermerken
	                   	    	  y.Intaktheitsfaktor=100																						  ; // Schiff wieder auf 100% Intaktheitsgrad setzen
	                   	    	  y.Inbetriebnahme_nach_Monaten=1																				  ; // aber es fr 1 Monat dafr aus dem Verkehr ziehen (steht ja in der Werft herum zum Streichen...)
	                   	    	  break Eingabe																								      ; // weitermachen mit neuem Monat
	                   	          }
    	            	       } 

    	                } // end for (Schiff y : Flotte)
    	
    	                break Eingabe; // eigentlich berflssig hier..., da oben im if Sprung schon erfolgt -> soll sich Compiler darum kmmern und optimieren
    	         		 
    	                //   -----------
	                    case Blaumachung:
	    	            //   -----------	                    	
	                    
	                    break Eingabe; // sofort fertig, weiter ohne nichts an der Stelle mit neuem Monat    	

    	                //   -------------
	                    case Programmende:
	    	            //   -------------	                    	
	                    
	                    // letzte Statistiken ausgeben

	                    InOut.printString("\nUnter Ihrem Kommando wurden: "  + Gesamtbauzaehler            + " Schiff(e) gebaut."                      );
		                InOut.printString("Unter Ihrem Kommando wurden: "    + Gesamtverschrottungszaehler + " Schiff(e) regulr verschrottet."        );
		                InOut.printString("Unter Ihrem Kommando versanken: " + Gesamtsinkzaehler           + " Schiff(e)."                             );
		                
	                    InOut.printString( "\nIhr Endkapital nach "+Monatscounter+" Monate(n) betrgt: "+String.valueOf(Betriebskasse.Kassenstand)+"\n");

	                    if (Betriebskasse.Kassenstand>Startkapital)
		                   InOut.printString("Dies entspricht einem Gewinn von: "  + String.valueOf(Startkapital-Betriebskasse.Kassenstand)            );	                    	
	                    if (Betriebskasse.Kassenstand<Startkapital)
	                       {
// System.out.printf("%.0f",Startkapital-Betriebskasse.Kassenstand); ginge auch
	                       InOut.printString("Dies entspricht einem Verlust von: "+ String.valueOf(Startkapital-Betriebskasse.Kassenstand)             );
	                       }
	                    else
			               InOut.printString("Dies entspricht einem Nullsummenspiel");
		                
		                
    					InOut.printString( "\nProgramm wurde beendet");
                        System.exit			           (Ende_regulaer); // alles ok, Endcode 0
                        break								   Eingabe; // eigentlich berflssig, da bereits exited wurde, aber der "Form halber" -> soll sich Compiler darum kmmern und optimieren
             
	                    default:
	                    continue Eingabe; // weiter mit Eingabe, bis was Brauchbares entschieden wurde
             
	            } // end switch(x)
	            
 	      } // end while (true) [Schleife mit der Hauptswitch-Anweisung]

	} // END while (true) [Spieldauerschleife]
	} // end public static void main(String[] args)
    } // end class