﻿/*
 
C#-Programm: RabattoCalco (c)2014 by www.gossmann.at
C#-Übung: T1I3
V0.9a - last mod: 061114

Aufgabenstellung:
-----------------

T1I3:
Eine Buchhandlung hat folgende Rabattstaffel: Bei einem Einkauf ab
500 € 20% Rabatt, von 300 € bis 499 € 14%, von 200 € bis 299 € 8% und
von 100€ S bis 199 € 3%. Unter 100 € wird kein Rabatt gewährt. Erstellen
Sie ein Programm, das aus dem Einkaufswert den Rabatt und den
rabattierten Preis berechnet!

Fleißaufgabe:

es erfolgt die Ausgabe des Rankings des Kunden, bzw. die Berechnung wie weit der von der nächsten Rabattstufe weg war (damit er sich ärgert)
sowie die Einführung einer zusätzlichen Superkunden-Stufe, wo der noch extra einen zusätzlichen Bonus (in diesem Fall ein Messerset) erhalten soll

weitere Ausbaumöglichkeiten für künftige Versionen:
---------------------------------------------------

- Konsolenoutput (Layout + Rundungen), bzw.
- statt Konsole überhaupt Inputoxen auf grafische Oberfläche verlagern
- aus Datenbank x-beliebig viele Rabattstufen holen lassen und in Schleife testen
- Geschenk des Tages auch wirklich als "Geschenk des Tages" per Zufallsgenerator aus Datenbank holen lassen

- Ranking der Kunden einführen:
  
  wie bei playtime.co.at mittels PHP und mySQL gemacht wurde, indem denen dann

  a) zusätzlich 2% Umsatzbonus 2x im Jahr einräumen
  b) -> heißt auch deren Umsatzwerte in einer Datenbank zu speichern anhand einer Kundennummer
  c) bzw. zum Geburtstag auch ein Geburtstagsrabatt gewährt wird (Geburtsdatumsfeld erfassen)

*/

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace RabattoCalco
{
    class Program
    {
        static void Main(string[] args)
        {

        const double C_dbl_angry_value       = 10                 ; // hier kann der Wert eingegeben werden, ab dem sich der Kunde ärgern soll, wenn er um diesen Betrag die nächste Rabattstufe verpasst hat
        const long   C_lg_supercustomer      =                 777; // hier kann jeder beliebige Wert genommen werden, ab dem man für den Kunden den roten Teppich auszurollen bereit ist (Superkunde)
        const string S_supercustomer_present = "Camping-Messerset"; // Geschenk, das dem Kunden beim Erreichen des "Superkunden-Status" als Bonus ausgehändigt werden soll

        bool         bl_supercustomer        =               false; // Flag, wenn Kunde ab 777 Euro einkauft, noch einen Extra-Luftballon kriegt, standardm. davon ausgehen, dass Kunde kein Superkunde ist (false)
        char         CH_wish_JN                                   ; // dient zur abschließenden J/N-Abfrage für Neustart des Programms        
        double       dbl_cash                =                   0; // eigentlicher Einkaufsbetrag
        double       dbl_cash_back           =                   0; // Rabattbetrag
        double       dbl_cust_next_limit     =                   0; // hiermit wird ausgerechnet, wie weit der Kunde von der nächsten Rabattstufe weg war..., standardm. 0, da es noch keine gibt

        // Initialisierungsteil:

        long LG_cust_idx = 0; // Indizes auf den Rang des Kunden (=sein Wert, ob man den hofieren muss, oder bei der Tür raustreten soll)

        // das eigentliche Kundenranking anhand der Rabattstufen (C zählt ab Index 0, das wäre aber eh der Kunde, der unter 100 gekauft hat und daher bei der Tür hinauszutreten wäre)

        string[] AS_customer_type =
        new string[] { "", "guter Kunde", "sehr guter Kunde", "einer unserer besten Kunden", "einer unserer allerbesten Kunden", "unser Superkunde" };

        LB_restart_prg:

        Console.Clear(); // Platz da am Konsolen-Schirm -> Wisch- und Weg machen...

        // dem User kurze Infos zum Programm und einen Erklärungsteil präsentieren:

        Console.WriteLine ("RabattoCalco V0.9a - (c) by www.gossmann.at, nov-2014:"          );
        Console.WriteLine                                                                 (""); // Übersichtsleerzeile einstreuen...
        Console.WriteLine ("RabattoCalco berechnet den gestaffelt gewährten Rabatt"          );
        Console.WriteLine ("anhand eines Einkaufswertes und zwar:"                           );
        Console.WriteLine                                                                 (""); // Übersichtsleerzeile einstreuen...
        Console.WriteLine ("Einkauf unter 100 Euro -  0%"                                    );
        Console.WriteLine ("Einkauf ab    100 Euro -  3%"                                    );
        Console.WriteLine ("Einkauf ab    200 Euro -  8%"                                    );
        Console.WriteLine ("Einkauf ab    300 Euro - 14%"                                    );
        Console.WriteLine ("Einkauf ab    500 Euro - 20%"                                    );
        Console.WriteLine ("Einkauf ab    777 Euro - 20%");
        Console.WriteLine                                                                 (""); // Übersichtsleerzeile einstreuen...        
        Console.WriteLine ("+ Bonus-Geschenk des Tages: das tolle " + S_supercustomer_present);

        // Eingabeteil: den Einkaufswert holen und auf Plausibilität prüfen
        // ----------------------------------------------------------------

        try
          {
          Console.WriteLine                             (""); // Übersichtsleerzeile einstreuen...
          Console.WriteLine ("Bitte Einkaufswert eingeben:");
          Console.WriteLine                             (""); // Übersichtsleerzeile einstreuen...
          dbl_cash = Convert.ToDouble (Console.ReadLine()  );
          }

        // ungültigen Wert bei Kovertierung entdeckt (alphanumerisches Zeugs) -> durch Exception-Handler abfangen

        catch
            {
            Console.WriteLine                                                                                                         (""); // Übersichtsleerzeile einstreuen...
            Console.WriteLine ("Leider haben Sie einen ungültigen Wert eingegeben - bitte auf Kommapunkt, bzw. Leerzeichen, etc. achten!");
            goto LB_restart_select                                                                                                        ; // mittels zwar verpöntem, aber leider an der Stelle notwendigem goto Neustartabfrage durchführen
            }

        // Kunde kann nicht "negativ" einkaufen, mittels zwar verpöntem, aber leider an der Stelle auch hier notwendigem goto neue Eingabe verlangen

        if (dbl_cash < 0)
           {
           Console.WriteLine                                                                                 (""); // Übersichtsleerzeile einstreuen...
           Console.WriteLine ("Hat Kunde etwas gestohlen, bzw. zurückgebracht (Gewährleistung? -> wegschicken!)");
           Console.WriteLine ("Ansonsten sind negative Einkaufswerte unzulässig!"                               );
           Console.WriteLine                                                                                 (""); // Übersichtsleerzeile einstreuen...
           Console.WriteLine ("Bitte Taste drücken!"                                                            );
           Console.ReadKey()                                                                                     ;
           goto LB_restart_prg                                                                                   ;
           }

        // Verarbeitungsteil: die Rabattstufen und das Kundenranking ausrechnen
        // --------------------------------------------------------------------
        
        // hat es der Kunde tatsächlich gewagt, nur unter 100 Euro einzukaufen?
        // dann dem freundlich sagen, dass er gefälligst mehr einkaufen soll!
        // und Ende an dieser Stelle, Rabatt gibt´s keinen, der ausgerechnet werden müsste,
        // sondern nur der Betrag um den der Kunde den Rabatt verpasst hat -> Feierabend für Programm

        if (dbl_cash < 100)
           {

           Console.WriteLine                                                                                              (""); // Übersichtsleerzeile einstreuen...
           Console.WriteLine ("Leider sind Sie unter der Grenze für einen Rabatt geblieben"                                  );
           Console.WriteLine                                                                                              (""); // Übersichtsleerzeile einstreuen...            
           Console.WriteLine ("Wenn Sie beim nächsten Mal ab dem Wert von 100 Euro einkaufen, gibt es tolle Rabatte für Sie!");

           LG_cust_idx = 0; // = Initialisierungswert und könnte daher hier so bleiben, wäre aber schlechter Programmierstil (wer weiß, wann die Routine in einer Schleife verwendet wird...)
           dbl_cust_next_limit = 100 - dbl_cash; // Betrag bis zur nächsten Rabattstufe ermitteln

           Console.WriteLine(""); // Übersichtsleerzeile einstreuen...            

           // hat Kunde erste Rabattstufe um weniger als (hier 10) Euro verfehlt, dann dem das melden, damit er sich fest ärgert!
           if (dbl_cust_next_limit < C_dbl_angry_value)
              {
              Console.WriteLine ("Bei Ihrem Einkauf im Wert von " + dbl_cash + " Euro haben Sie unsere erste Rabattstufe leider nur um: " + dbl_cust_next_limit + " Euro verfehlt!");
              Console.WriteLine                                                                                                                                                 (""); // Übersichtsleerzeile einstreuen...            
              Console.WriteLine ("Daher bleibt es leider bei der vollen zu zahlenden Summe von " + dbl_cash + " Euro."                                                             );
              }

           // war nächste Rabattstufe (hier mehr als 10 Euro Konstantenwert) entfernt, dann normale Meldung machen, dass es grundsätzlich weitere Rabattstufen geben würde

           else
              {
              Console.WriteLine ("Wir möchten Sie darauf hinweisen, dass Sie bei Ihrem Einkauf im Wert von " + dbl_cash + " Euro noch " + dbl_cust_next_limit + " Euro unter der ersten Rabattstufe geblieben sind!");
              Console.WriteLine                                                                                                                                                                                  (""); // Übersichtsleerzeile einstreuen...            
              Console.WriteLine ("Daher bleibt es bei der vollen zu zahlenden Summe von " + dbl_cash + " Euro."                                                                                                     );
              }

           goto LB_restart_select; // zur Nachfrage, ob nochmal berechnet werden soll

           } // END:  if (dbl_cash < 100)...

        // hat Kunde schon mehr Geld im Laden gelassen (bis max. 199 Euro)?
        // dann dem schon etwas mehr bieten und Kunde entsprechend einstufen sowie Rabattbetrag (3%) errechnen

        // Test auf >=100 kann hier entfallen, da Betrag oben schon nicht < 100 war - wo Programm neu gestartet worden wäre -> also ist er schon mal größer und Rabattausrechnungen beginnen:

        if (dbl_cash < 200)
           {
           dbl_cash_back = dbl_cash / 100 * 3  ; // Rabattformel: Grundwert durch 100 * Rabattprozent = Rabattbetrag
           dbl_cust_next_limit = 200 - dbl_cash; // Betrag bis zur nächsten Rabattstufe ermitteln               
           LG_cust_idx = 1                     ; // Einsufungsfeldindex setzen für Ausgabestring
           }

        // hat Kunde bis max. 299 Euro eingekauft?
        // dann dem schon um Einiges mehr bieten Kunde entsprechend einstufen sowie Rabattbetrag (8%) errechnen

        if ( (dbl_cash >= 200) && (dbl_cash < 300) )
           {
           dbl_cash_back = dbl_cash / 100 * 8  ; // Rabattformel: Grundwert durch 100 * Rabattprozent = Rabattbetrag
           dbl_cust_next_limit = 300 - dbl_cash; // Betrag bis zur nächsten Rabattstufe ermitteln                              
           LG_cust_idx = 2                     ; // Einsufungsfeldindex setzen für Ausgabestring
           }

        // hat Kunde bis max. 499 Euro eingekauft?
        // dann dem ordentlich was bieten, ihn auch ordentlich einstufen und den dafür gewährten Rabatt (14%) errechnen

        if ( (dbl_cash >= 300) && (dbl_cash < 500) )
           {
           dbl_cash_back = dbl_cash / 100 * 14 ; // Rabattformel: Grundwert durch 100 * Rabattprozent = Rabattbetrag
           dbl_cust_next_limit = 500 - dbl_cash; // Betrag bis zur nächsten Rabattstufe ermitteln (wäre hier dann die Superkundenstufe)
           LG_cust_idx = 3                     ; // Einsufungsfeldindex setzen für Ausgabestring
           }

        // an dieser Stelle ist beim Einkaufsbetrag von mind. 500 Euro dem Kunden 20% Rabatt zu gewähren

        if (dbl_cash >= 500)
           {
           dbl_cash_back = dbl_cash / 100 * 20                ; // Rabattformel: Grundwert durch 100 * Rabattprozent = Rabattbetrag
           dbl_cust_next_limit = C_lg_supercustomer - dbl_cash; // Betrag bis zur Superkundenstufe für das Bonus-Geschenk ermitteln
           LG_cust_idx = 4                                    ; // Einsufungsfeldindex setzen für Ausgabestring
           }

        // hat Kunde Superkunden-Stufe erreicht?

        if (dbl_cash >= C_lg_supercustomer)
           {
           bl_supercustomer = true; // ja -> dann vermerken, dass der rote Teppich auszurollen wäre und der sein Bonus-Geschenk erhält...
           // Superkundeneinstufung vornehmen (theor. würde man sich damit die BOOL-Varialbe sparen können durch if (LG_cust_idx == 5) {...}
           // so ist es aber eleganter und übersichtlicher / logischer - eine BOOL-Variable kostet ja läppische 8 Bytes
           // für 64-Bit optimierte CPUs sind JE-true-Vergleiche ohnehin schneller als CMP-Vergleiche auf Maschinenebene für Test auf Wert 5
           LG_cust_idx =         5; // Superkundeneinstufung vornehmen
           }
        else
           {
           bl_supercustomer = false; // nein -> dann ebenfalls vermerken, dass der rote Teppich wohl nicht zu putzen ist nachher...
           }

        // Ausgabeteil:
        // ------------            

        Console.WriteLine                                                                                                                                              (""); // Übersichtsleerzeile einstreuen...
        Console.WriteLine ("Als " + AS_customer_type[LG_cust_idx] + " erhalten Sie für Ihren Einkauf im Wert von " + dbl_cash + " Euro " + dbl_cash_back + " Euro Rabatt.");
        Console.WriteLine                                                                                                                                              (""); // Übersichtsleerzeile einstreuen...
        Console.WriteLine ("Jetzt zahlen Sie nur noch: " + (dbl_cash - dbl_cash_back) + " Euro! Ist das nicht toll?"                                                      );
        Console.WriteLine                                                                                                                                              (""); // Übersichtsleerzeile einstreuen...

        // beim "Superkunden", diesem noch das Camping-Messerset aushändigen lassen...
        // der kommt dann vielleicht wieder und kauft sich noch das teure Zelt um 890,- mit Gewinn von 380,- Euro auch dazu...
        // den nur ja nicht Rabattmeldungen belästigen (außerdem gibt es auch keine weiteren Rabattstufen mehr und die Ausgabe des Wertes in "dbl_cust_next_limit" hat für den Superkunden zu unterbleiben)

        if (bl_supercustomer) // handelt es sich um den Superkunden?
           {
           // den roten Teppich ausrollen und das Bonus-Geschenk aushändigen lassen!!!
           // der "Superkunde" soll sich auch nicht ärgern, da es natürlich auch keine weiteren Rabattstufen mehr gibt... - gleich Einleitung der Neustartabfrage des Programms veranlassen
           Console.WriteLine ("Bitte schreiten Sie noch am roten Teppich zum Infoschalter und holen Sie sich Ihr persönliches " + S_supercustomer_present + " als Extra-Bonus-Geschenk!");
           goto LB_restart_select                                                                                                                                                        ; 
           }

        // ansonsten sollen sich "normale Kunden" ärgern, wenn:
        // nächste Rabattstufe nur noch unter 10 Euro entfernt war (hier im Programm der Konstantenwert), damit die das nächste Mal gefälligst mehr einkaufen...
        // Unterscheidung muss nur noch getroffen werden, ob die Superkundenstufe vorliegt (bei der es ja keine weiteren Rabatte mehr gibt, sondern das Extra-Bonus-Geschenk

        if (dbl_cust_next_limit < C_dbl_angry_value)
           {

           if (LG_cust_idx == 4) // ist Kunde schon auf höchster Rabattstufe?
              {
              // ja -> dann dem melden, wie weit er von der Superkunden-Stufe weg war, damit er sich ärgert, das Bonus-Geschenk nicht gekriegt zu haben
              Console.WriteLine ("Bei Ihrem Einkauf im Wert von " + dbl_cash + " Euro haben Sie die Superkunden-Stufe mit Extra-Bonus-Geschenk leider nur um " + dbl_cust_next_limit + " Euro verfehlt!");
              }
           else
              {
              // nein -> dann dem normal melden, wie weit er von der Superkunden-Stufe weg war (=das es diese natürlich auch noch gibt)
              Console.WriteLine ("Bei Ihrem Einkauf im Wert von " + dbl_cash + " Euro haben Sie unsere nächste Rabattstufe leider nur um " + dbl_cust_next_limit + " Euro verfehlt!");
              }

           }

        // war nächste Rabattstufe (hier mehr als 10 Euro Konstantenwert) entfernt, dann normale Meldung machen, dass es grundsätzlich weitere Rabattstufen geben würde

        else // if (dbl_cust_next_limit < C_dbl_angry_value)

           {

           if (LG_cust_idx == 4) // ist Kunde schon auf höchster Rabattstufe?
              {
              Console.WriteLine ("Wir möchten Sie darauf hinweisen, dass Sie bei Ihrem Einkauf im Wert von " + dbl_cash + " Euro noch " + dbl_cust_next_limit + " Euro unter der Superkunden-Stufe geblieben sind!");
              }
           else
              {
              Console.WriteLine ("Wir möchten Sie darauf hinweisen, dass Sie bei Ihrem Einkauf im Wert von: " + dbl_cash + " Euro noch: " + dbl_cust_next_limit + " Euro unter der nächsten Rabattstufe geblieben sind!");
              }

           } // END if (dbl_cust_next_limit < C_dbl_angry_value)

        // Programmneustartsabfrage (es gibt Dinge, die gehen eben nur mit goto...)

        LB_restart_select:
 
        Console.WriteLine                                  (""); // Übersichtsleerzeile einstreuen...
        Console.WriteLine        ("noch eine Berechnung (j/n)");

        CH_wish_JN = Convert.ToChar (Console.ReadKey().KeyChar); // Taste holen lassen
        CH_wish_JN = char.ToLower                  (CH_wish_JN); // nur Kleinschreibung testen, damit nicht auch Großbuchstaben getestet werden müssen im Switch

        switch (CH_wish_JN)
               {
               case 'j': goto LB_restart_prg   ; // Neustart
               case 'n': return                ; // Feierabend
               default : goto LB_restart_select; // ungültige Taste gedrückt (kein j/n)
               }

        }
    }
}
