﻿/*

C#-Programm: Burglerhunt (c)2014 by www.gossmann.at
C#-Übung: T2K5 – Hundezwinger
V0.9a - last mod: 181214

Aufgabenstellung (Zweck: Klassen u. Methodendeklarationen und -aufrufe lernen):
-------------------------------------------------------------------------------

Implementieren Sie die Klasse Hund mit Instanzvariablen für Name und Alter des Hundes. Weiters
hat die Klasse Hund eine Methode Bellen(). Legen Sie ein Array mit 3 Hunde-Objekten an und lassen
Sie dann alle Hunde bellen.

Fleißaufgabe, da Programm sonst eigentlich nichts machen würde:

Hunde zufällige Anzahl an Bellgeräuschen ausgeben lassen (=bellt keiner, kann der Einbrecher ungestört die Wohnung ausräumen), Neustart-Frage
-> allenfalls durch bedingte Compilierung normale Variante mit regulärem Bellen erzeugbar

weitere Optimierungsmöglichkeiten:
----------------------------------

Hundenamen und Geschlecht auch zufallsmäßig zuweisen

Hinweis:
--------

d. Klasse "Hund" wurde im Programm als "OBJ_dog" implementiert -> Grund: "OBJ" als Kennung für "OBJect" und "dog", damit es international ist (Englisch)
bei normalen Methoden wäre es ja egal, wie die heißen, bei Objekten allerdings nicht, wenn die jemand nutzen möchte.

aus dem gleichen Grund wurden die Variablen für Name und Alter angepasst in

this.S_dogname    =    S_dogname; ("S" -> String)

this.LG_dogage    =    LG_dogage; ("LG" -> Long: der echte "Long" von C# hat zwar 64 Bit - da ich allerdings mehr in Pascal programmiert habe und der dortige LONG eben nur 32-Bit hat,
wie eben der INT von C#, ist es zwecks Wertbereichsübereinstimmung dabei geblieben (echte Longs hätte ich mit CLG_xxxxxxxx gekennzeichnet)

sowie zusätzlich das Geschlecht in

this.CR_doggender = CR_doggender; (CR -> Character)

=eine Art eigene sog. ungarische Notation
 
*/

/* wenn folgende Kommentarstriche entfernt werden, compiliert das Programm genau wie in der Aufgabenstellung (normales Bellen, ansonsten wird die Einbrechervariante compiliert). */

// #define regular_PRG

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace burglerhunt
{
    class Program
    {
        
        public static bool yesno_Q(bool BL_key_only)
        {
             
        char CH_wish_JN; // dient der J/N-Abfrage

        LB_restart_select:
            CH_wish_JN = Convert.ToChar (Console.ReadKey().KeyChar); // Taste holen lassen
            CH_wish_JN = char.ToLower   (CH_wish_JN)               ; // nur Kleinschreibung testen, damit nicht auch Großbuchstaben getestet werden müssen im Switch

            if (BL_key_only) return true; // wenn nur auf Taste gewartet werden soll, einfach true dafür liefern und zum Aufrufer zurückkehren, ansonsten wird unten zwischen (j,n) unterschieden

            switch (CH_wish_JN)
            {
                case 'j': return true          ; // Wunsch ja übergeben - was Aufrufer mit der Info macht = sein Kaffee
                case 'n': return false         ; // Wunsch nein übergeben - was Aufrufer mit der Info macht = auch sein Kaffee
                default: goto LB_restart_select; // ungültige Taste gedrückt (kein j/n) - User nicht aus der Methode lassen, solange er nicht das gewünschte drückt
            }
        } // END-method: yesno_Q

        static void Main(string[] args)
        {

            // Deklarations- u. Initialisierungsteil:
            // --------------------------------------

            // Hunde gibt es
            const char CR_w = 'w'     ; // sowohl Weibchen
            const char CR_m = 'm'     ; // als auch Männchen
            int        LG_items_stolen; // Anzahl der gestohlenen Gegenstände
            int        LG_lazy_dogs   ; // Anzahl der Faulpelze, die nicht bellen
            int        LG_x           ; // Schleifenzähler

            LG_lazy_dogs = 0; // standardmäßig davon ausgehen, dass alle Hunde brav bellen

            Random OBJ_random   = new Random  (); // für jeden Hund als Aufputz bei jedem Lauf das Alter zufallsmäßig setzen lassen
            OBJ_dog[] OBAR_dogs = new OBJ_dog[3]; // 3 Hunde werden sind laut Aufgabenstellung im Zwinger - spaßhalber könnte man auch untiges Zeug einbauen und akt. Zeile auskommentieren

            Console.Clear(); // Platz da am Konsolen-Schirm -> Wisch- und Weg machen...

            // dem User kurze Infos zum Programm und einen Erklärungsteil präsentieren:

            Console.WriteLine ("Burglerhunt V0.9a - (c) by www.gossmann.at, dec-2014:"     );
            Console.WriteLine (""                                                          ); // Übersichtsleerzeile einstreuen...
#if regular_PRG
            /* bei reinem Bellen aller Hunde hätte der Einbrecher keine Chance */
            Console.WriteLine ("T R A I N E R - M O D E *** T R A I N E R - M O D E"       );
            Console.WriteLine (""                                                          ); // Übersichtsleerzeile einstreuen...
#endif
            Console.WriteLine ("Burglerhunt wartet auf einen Tastendruck und lässt danach" );
            Console.WriteLine ("einen Einbrecher einen Einbruchsversuch starten."          );
            Console.WriteLine (""                                                          ); // Übersichtsleerzeile einstreuen...
            Console.WriteLine ("In einem Hundezwinger lauern allerdings drei Hunde. Je"    );
            Console.WriteLine ("nachdem, wie viele davon bellen oder nicht, verläuft der"  );
            Console.WriteLine ("Einbruch mehr oder weniger erfolgreich."                   );
            Console.WriteLine (""                                                          ); // Übersichtsleerzeile einstreuen...

            // kurzer Eingabeteil: nur User fragen, wann er den Einbruchsversuch starten will und riskiert von den Hunden im Zwinger gemeldet zu werden
            // Zufallserzeugung vom Bellen (Anzahl der Belllaute) ist ja auch abhängig vom Timer des PCs und Initwert des Random-Objekts...
            // ----------------------------------------------------------------------------------------------------------------------------------------

            Console.WriteLine("Bitte Taste drücken, wenn der Einbruchsversuch starten soll!");

            if (yesno_Q(true)) {} // nur auf beliebigen Tastendruck warten, ohne j,n-Unterscheidung

            LB_restart_prg: // "nullen" der Objekte falls aus Neustartabfrage hereingesprungen wurde und somit Programmreinitialisierung erfolgen muss

            for (LG_x = 0; LG_x < OBAR_dogs.Length; LG_x++ ) // alle Objekte nullen
                {
                OBAR_dogs[LG_x] = null;
                }

            // jetzt Objekte "richtig" initialisieren

            OBAR_dogs[0] = new OBJ_dog ("Herr Bezirksrat", OBJ_random.Next( 2,    15), CR_m); // Hund vom Kaisermühlen Blues soll zwischen 2 und 14 Jahren alt sein
            OBAR_dogs[1] = new OBJ_dog ("Lassie"         , OBJ_random.Next( 3,    10), CR_w); // von der Fernsehserie soll zwischen 3 und 9 Jahren alt sein
            OBAR_dogs[2] = new OBJ_dog ("Cerberus"       , OBJ_random.Next(20, 10001), CR_m); // Cerberus vom Tor zur Hölle soll zwischen 20 und 10.000 Jahren alt sein*/

            Console.Clear(); // Platz da am Konsolen-Schirm -> Wisch- und Weg machen...

            LG_lazy_dogs    = 0; // Faulpelzzähler mit 0 initialisieren, d.h. standardmäßig davon ausgehen, dass alle Hunde brav bellen und keine Faulpelze sind
            LG_items_stolen = 0; // gestohlene Gegenstände mit 0 initialisieren

            // Verarbeitungs- u. Ausgabeteil einleiten:
            // ----------------------------------------

            foreach (OBJ_dog dog in OBAR_dogs) // alle Objekte (Hunde) abgrasen
            {

#if regular_PRG
                /* SO MÜSSTE ES SEIN, WIE IN DER AUFGABENSTELLUNG -> DANN WÜRDE JEDER HUND MIND 1x BELLEN:

                // zwischen 1 und 3 Belllauten ausgeben -> hier würde "Faulpelzfall" nicht auftreten und die Hunde würde allesamt eine best. Anzahl "bellen"
                // in diesem Fall gehört nachfolgendes if aber auskommentiert und der Einbrecher würde niemals eine Chance haben, erfolgreich einzubrechen
                */

               dog.wau_wau(OBJ_random.Next(1, 4)); // zwischen mind. 1 und max. 3 Belllaute ausgeben lassen
#endif

#if !regular_PRG
               /* Hier folgt der lustigere Einbrechervariantenaufruf: */

               if (dog.wau_wau(OBJ_random.Next(0, 4)) == false) // zwischen 0 und 3 Belllauten ausgeben (bei mehr Zufallswerten und 3 Hunden wäre Wahrscheinlichkeit für Einbruchserfolg gering)
               {                                                // -> 0 wird in Klasse als "Faulpelzfall" behandelt und gibt dem Einbrecher die Chance, die Wohnung auszuräumen...
                    LG_lazy_dogs++;
                    LG_items_stolen += OBJ_random.Next(1, 13) ; // für jeden schlafenden Hund zwischen mind. 1 und einem Dutzend Gegenstände stehlen lassen
               }
#endif
            }

            Console.WriteLine(); // Übersichtsleerzeile einstreuen...

#if !regular_PRG

            /* Einbrechervariante */

            if ( (LG_lazy_dogs > 0) &&  (LG_lazy_dogs != OBAR_dogs.Length) )                                                  // befanden sich Faulpelze unter den Hunden, allerdings waren nicht alles Faulpelze?
               {                                                                                                              // ja -> Teilerfolg / Teilverlust melden (je nach Sichtweise)
               if (LG_items_stolen == 1)                                                                                      // Einzahl und Mehrzahl von "Gegenstand" unterscheiden
                  {
                  Console.WriteLine("Der Einbrecher war in der Lage " + LG_items_stolen + " Gegenstand mitgehen zu lassen,"); // und je nachdem ausgeben lassen
                  }
               else
                  {
                  Console.WriteLine("Der Einbrecher war in der Lage " + LG_items_stolen + " Gegenstände mitgehen zu lassen,");
                  }
               Console.WriteLine("da es die folgende Anzahl an Faulpelzen gab: " + LG_lazy_dogs                             );
               }
            // Wahrscheinlichkeit: ~ 4%, dass alles Faulpelze sind
            if (LG_lazy_dogs == OBAR_dogs.Length)                                                                              // waren nun alle Faulpelze?
               {
               Console.WriteLine("Alle Ihre Wauwaus waren Faulpelze!"                                                       );
               Console.WriteLine("Der Einbrecher konnte Ihnen die Wohnung leider komplett ausräumen."                       ); // ja -> Wohnung leer melden
               Console.WriteLine("Alle " + LG_items_stolen + " Wertsachen sind weg!"                                        );
               }
#endif
            if (LG_lazy_dogs == 0)                                                                                             // blieb es bei 0 Faulpelzen?
               {
               Console.WriteLine("Alle Ihre Wauwaus waren wachsam - der Einbrecher wurde in die Flucht geschlagen!"         ); // vollen Erfolg melden
               }

            Console.WriteLine(""                                       ); // Übersichtsleerzeile einstreuen...
            Console.WriteLine("noch einen Einbruchsversuch wagen (j/n)");
            if (yesno_Q(false)) goto LB_restart_prg                     ; // wurde "j" gedrückt, dann Programm neu starten

        }
    }
}
