﻿/*

C#-Programm: Mitarbeiter_Hierarchie (c)2015 by www.gossmann.at
C#-Übung: T2H7 – Mitarbeiter
V0.9 - last mod: 170115

Aufgabenstellung (Zweck: Klassen u. Methodendeklarationen und -aufrufe lernen):
-------------------------------------------------------------------------------

T2H7 - Mitarbeiter
Entwerfen Sie eine Klassenhierarchie für Mitarbeiter eines Unternehmens. Das Unternehmen
beschäftigt Arbeiter, Angestellte, Manager und einen CEO. Die nachfolgende Tabelle zeigt, welche
Eigenschaften bei welchen Mitarbeitern vorhanden sind.
Personal
nummer
Name Adresse Eintrittsjahr Stundenlohn Schichtzulage Bonus Optionen
Arbeiter √ √ √ √ √ √
Angestellter √ √ √ √ √
Manager √ √ √ √ √ √
CEO √ √ √ √ √ √ √
Copyright Walter Taus Programmieren C# Teil 2 12
In der Klassenhierarchie implementieren Sie Methoden zum Drucken aller Mitarbeiterdetails und
eine Methode zur Berechnung des Monatsgehaltes unter der Annahme von 154 Stunden pro Monat.
Berechnen Sie die Summe der monatlichen Lohnkosten aller Mitarbeiter.
 
*/

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace T2H7
{
    class Program
    {
        static void Main(string[] args)
        {

        double gesamtgehalt = 0; // Gesamtgehalt initialisieren - wird nachher in den Schleifen berechnet
        int    x               ; // Schleifenzähler für Berechnung des Gesamtgehalts nachher

        // exemplarisch jeweils 3 Mitarbeiter für jeden Typ reservieren lassen

        Arbeiter     [] arbeiter     = new Arbeiter     [3];
        Angestellter [] angestellter = new Angestellter [3];
        Manager      [] manager      = new Manager      [3];
        CEO          [] ceo          = new CEO          [3];

        // d. einzelnen Detaildaten den Mitarbeitern initialisieren

        arbeiter[0]     = new Arbeiter     ( 1, "Tick Duck"                      , "Entenstr. 4a / 1234 Entenhausen"      , 1960,  5.05,  1.28      );
        arbeiter[1]     = new Arbeiter     ( 2, "Trick Duck"                     , "Entenstr. 4b / 1234 Entenhausen"      , 1961,  5.08,  1.12      );
        arbeiter[2]     = new Arbeiter     ( 3, "Truck Duck"                     , "Entenstr. 4c / 1234 Entenhausen"      , 1962,  4.99,  1.02      );

        angestellter[0] = new Angestellter ( 4, "Edmund Sackbauer"               , "Hasengasse 19 / 1040 Wien"            , 1977,  8.25             );
        angestellter[1] = new Angestellter ( 5, "Heinz Müller"                   , "Kirchengasse 34 / 8020 Wien"          , 1979,  9.17             );
        angestellter[2] = new Angestellter ( 6, "Gerhard Schulze"                , "Hotterweg 21 / 7000 Eisenstadt"       , 1981, 10.11             );
 
        ceo[0]          = new CEO          ( 7, "Dr. Richard Maier"              , "Eggengasse 11 / 7123 Mönchhof"        , 1982, 40.45, 10.44, 5.23);
        ceo[1]          = new CEO          ( 8, "Mag. Heidemarie Heidl"          , "Bahnstr. 39 / 6992 Hirschegg"         , 1984, 30.08,  9.08, 4.33);
        ceo[2]          = new CEO          ( 9, "DDr. Walter Weidler"            , "Marktgasse 4c / 7132 Frauenkirchen"   , 1987, 50.28, 22.32, 7.88);

        manager[0]      = new Manager      (10, "Dir. Josef Jedler"              , "Hauptstr. 12 / 2485 Wimpassing a.d.L.", 1987, 60.45, 15.44      );
        manager[1]      = new Manager      (11, "Amtsr. Kunigunde Hafner"        , "Schifffahrtsweg 2 / 8160 Weiz"        , 1987, 52.78, 11.08      );
        manager[2]      = new Manager      (12, "Hofr. Dipl. Ing. Leopold Lustig", "Teichg. 4c / 6294 Hintertux"          , 1992, 70.44, 23.64      );

        Console.Clear(); // Platz da am Konsolen-Schirm -> Wisch- und Weg machen...

        // dem User kurze Infos zum Programm und einen Erklärungsteil präsentieren:

        Console.WriteLine ("Mitarbeiter-Hierarchie V0.9 - (c) by www.gossmann.at"    );
        Console.WriteLine ("jan-2015\n"                                              );
        Console.WriteLine ("Mitarbeiter-Hierarchie implementiert Mitarbeiter-Klassen");
        Console.WriteLine ("und ruft jeweils drei Beispiele exemplarisch auf"        );            
        Console.WriteLine ("Arbeiter, Angestellte, CEOs, Manager\n"                  ); 
        Console.WriteLine (""                                                        );  
        Console.WriteLine ("Außerdem wird das monatliche Gesamtgehalt berechnet"     );   
        Console.WriteLine (""                                                        );  

        // d. einzelnen Daten mit den Objektmethoden ausgeben lassen und gleichzeitig das Gesamtgehalt unter Ausnutzung der Ausgabeschleifen aufsummieren lassen

        // alle Arbeiter abgrasen lassen

        for (x = 0; x < manager.Length; x++)
            {
            arbeiter[x].Drucken                                 (); // Arbeiterinfos ausgeben lassen
            Console.WriteLine                                 (""); // Übersichtsleerzeile;
            gesamtgehalt = gesamtgehalt + arbeiter[x].Monatsgehalt; // Gesamtgehalt aufsummieren
            }
        
        // alle Angestellten abgrasen lassen
        
        for (x = 0; x < manager.Length; x++)
            {
            angestellter[x].Drucken                                 (); // Angestellteninfos ausgeben lassen
            Console.WriteLine                                     (""); // Übersichtsleerzeile;
            gesamtgehalt = gesamtgehalt + angestellter[x].Monatsgehalt; // Gesamtgehalt aufsummieren
           }

        // alle CEOs abgrasen lassen

        for (x = 0; x < manager.Length; x++)
            {
            ceo[x].Drucken                                 (); // CEOs-Infos ausgeben lassen
            Console.WriteLine                            (""); // Übersichtsleerzeile;
            gesamtgehalt = gesamtgehalt + ceo[x].Monatsgehalt; // Gesamtgehalt aufsummieren
            }

        // alle Manager abgrasen lassen

        for (x = 0; x < manager.Length; x++)
            {
            manager[x].Drucken                                 (); // Manager-Infos ausgeben lassen
            Console.WriteLine                                (""); // Übersichtsleerzeile;
            gesamtgehalt = gesamtgehalt + manager[x].Monatsgehalt; // Gesamtgehalt aufsummieren
            }

        // monatliches Gesamtgehalt aller Mitarbeiter ausgeben

        Console.WriteLine("Sämtliche Mitarbeiter kosten monatlich: " + gesamtgehalt + " Euro.");

        }
    }
}
